<?php
require_once( 'utility.php' ) ;
function setup_nat_network_isolated( $argv ) {
	global $DTASCFG_XML_FILE ;

	$xml     = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $usbxcli = chop( $xml -> u_sandbox -> cli_path ) ;

    try {
        $ret_array = run_program_at_sc_by_ssh( array(
            'exit_when_error' => 0,
            'program'   => "/usr/bin/python", 
            'arguments' => array(
                $usbxcli,
                "set-gateway",
                "--type", "isolated" ) ) ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "FailToIsolateNatNetwork: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "SuccessToIsolateNatNetwork: $stdoutMsg" ) ;
        
        exit( 0 ) ;
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        shm_print_error( $msg ) ;
        debug_print( "Exception caught: $msg" ) ;
        exit( 1 ) ;
    }
}

